<?php
// VALID DEFINITIO ACTION
if (! empty($_POST['action'])):
  session_start();
  include_once("../../conf/conf.php");
  // VALID ACTION
  switch($_POST['action']):
      case "proccessDeleteInfoProduct":
        // FUNCION PROCCESS DELETE INFO PRODUCT
        proccessDeleteInfoProduct($dbh, $_POST['product']);
      break;
  endswitch;
endif;
// FUNCTION VALID BILLED PRODUCT
function validBilledProduct($dbh, $product){
  // QUERY
  $sql = "SELECT rowid FROM fi_facturas_detalle WHERE fk_producto =:fk_producto;";
  $db  = $dbh->prepare($sql);
  $db->bindValue(":fk_producto", $product, PDO::PARAM_INT);  
  $result = $db->execute();
  $data   = $db->fetch(PDO::FETCH_OBJ);
  $row    = $db->rowCount();
  $status = (($row)>0)? true: false;
  // RETURN
  return $status;
}
// FUNCTION VALID QUOTED PRODUCT
function validQuotedProduct($dbh, $product){
  // QUERY
  $sql = "SELECT rowid FROM fi_cotizaciones_detalle WHERE fk_producto =:fk_producto;";
  $db  = $dbh->prepare($sql);
  $db->bindValue(":fk_producto", $product, PDO::PARAM_INT);  
  $result = $db->execute();
  $data   = $db->fetch(PDO::FETCH_OBJ);
  $row    = $db->rowCount();
  $status = (($row)>0)? true: false;
  // RETURN
  return $status;
}
// FUNCTION VALID PURCHASE PRODUCT
function validPurchaseProduct($dbh, $product){
  // QUERY
  $sql = "SELECT rowid FROM fi_compras_detalle WHERE fk_producto =:fk_producto;";
  $db  = $dbh->prepare($sql);
  $db->bindValue(":fk_producto", $product, PDO::PARAM_INT);  
  $result = $db->execute();
  $data   = $db->fetch(PDO::FETCH_OBJ);
  $row    = $db->rowCount();
  $status = (($row)>0)? true: false;
  // RETURN
  return $status;
}
// FUNCION PROCCESS DELETE INFO PRODUCT
function proccessDeleteInfoProduct($dbh, $product){
  $array = array();
  // FUNCTION VALID BILLED PRODUCT
  if (!validBilledProduct($dbh, $product)):
    // FUNCTION VALID QUOTED PRODUCT
    if (!validQuotedProduct($dbh, $product)):
      // FUNCTION VALID PURCHASE PRODUCT
      if (!validPurchaseProduct($dbh, $product)):
        // FUNCTION DELETE INFO PRICE PRODUCT
        $result = deleteInfoPriceProduct($dbh, $product);
        // FUNCTION DELETE INFO COST PRODUCT
        $result = deleteInfoCostProduct($dbh, $product);
        // FUNCTION DELETE INFO STOCK PRODUCT
        $result = deleteInfoStockProduct($dbh, $product);
        // FUNCTION DELETE INFO PRODUCT
        $result = deleteInfoProduct($dbh, $product);
        // VALID RESULT
        if ($result):
          $array = array('result' => 1, 'message' => 'Proceso de eliminación de la información del producto, realizado co éxito.');
        else:
          $array = array('result' => 0, 'message' => 'Se presento un error en el proceso de eliminación de la información del producto.');
        endif;
      else:
        $array = array('result' => 0, 'message' => 'El producto; ya se encuentra inventariado con anterioridad; por lo que no se puede eliminar.');
      endif;
    else:
      $array = array('result' => 0, 'message' => 'El producto; ya se encuentra cotizado con anterioridad; por lo que no se puede eliminar.');
    endif;
  else:
    $array = array('result' => 0, 'message' => 'El producto; ya se encuentra facturado con anterioridad; por lo que no se puede eliminar.');
  endif;
  // RETURN
  echo json_encode($array);
}
// FUNCTION DELETE INFO PRICE PRODUCT
function deleteInfoPriceProduct($dbh, $product){
  // QUERY
  $sql  = "DELETE FROM fi_productos_precios_clientes WHERE fk_producto =:fk_producto;";
  $db   = $dbh->prepare($sql);    
  $db->bindValue(":fk_producto", $rowid, PDO::PARAM_INT);  
  $result = $db->execute();  
  // RETURN
  return $result;
}
// FUNCTION DELETE INFO COST PRODUCT
function deleteInfoCostProduct($dbh, $product){
  // QUERY
  $sql  = "DELETE FROM fi_productos_precios_costo WHERE fk_producto =:fk_producto;";
  $db   = $dbh->prepare($sql);    
  $db->bindValue(":fk_producto", $rowid, PDO::PARAM_INT);  
  $result = $db->execute();  
  // RETURN
  return $result;
}
// FUNCTION DELETE INFO STOCK PRODUCT
function deleteInfoStockProduct($dbh, $product){
  // QUERY
  $sql  = "DELETE FROM fi_bodegas_productos_configuracion WHERE fk_producto =:fk_producto;";
  $db   = $dbh->prepare($sql);    
  $db->bindValue(":fk_producto", $rowid, PDO::PARAM_INT);  
  $result = $db->execute();  
  // RETURN
  return $result;
}
// FUNCTION DELETE INFO PRODUCT
function deleteInfoProduct($dbh, $product){
  // QUERY
  $sql  = "DELETE FROM fi_productos WHERE rowid =:rowid;";
  $db   = $dbh->prepare($sql);    
  $db->bindValue(":rowid", $product, PDO::PARAM_INT);  
  $result = $db->execute();  
  // RETURN
  return $result;
}
?>