<?php

class Productos
{

    private $db;

    public $id;
    public $tipo;
    public $ref;
    public $fk_bodega_base;
    public $cbproveedor;
    public $cbinterno;

    public $label;
    public $tosell;
    public $tobuy;
    public $fk_user_autor;
    public $stock;
    public $stock_minimo_alerta;
    public $notas;

    public $codigo_barras;

    public $conversion_venta;
    public $conversion_venta_numero;
    public $conversion_compra;
    public $conversion_compra_numero;
    public $entidad;

    public $diccionario_1;
    public $diccionario_2;
    public $diccionario_3;
    public $diccionario_4;
    public $diccionario_5;
    public $diccionario_6;
    public $diccionario_7;
    public $diccionario_8;
    public $diccionario_9;
    public $diccionario_10;
    public $romana;

// parametro Extra
    public $tipo_texto; // nos dice en texto si es producto o servicio

    public function __construct($db)
    {$this->db = $db;}

    public function nuevo($usuario, $datos)
    {
        global $_SESSION;

        $sql = "insert into fi_productos
                                 (
                                  entidad ,
                          tipo,
                                  ref,

                                  label,
                                  codigo_barras ,
                                  tosell ,
                                  tobuy  ,
                                  fk_user_autor ,
                                  stock_minimo_alerta ,

                                  notas,
                                  diccionario_1 ,
                                  diccionario_2 ,
                                  diccionario_3 ,
                                  diccionario_4 ,
                                  diccionario_5 ,
                                  diccionario_6 ,
                                  diccionario_7 ,
                                  diccionario_8 ,
                                  diccionario_9 ,
                                  diccionario_10,
                                  romana        ,
                                  unidad  ,
                                  descuento_maximo )
                                  values
                                 (
                                  '" . $_SESSION['Entidad'] . "' ,
                :tipo,
                                  :ref,

                                  :label,
                                  :codigo_barras,

                                  :tosell ,
                                  :tobuy  ,
                                  :fk_user_autor ,
                                  :stock_minimo_alerta,


                                  :notas ,
                                  :diccionario_1 ,
                                  :diccionario_2 ,
                                  :diccionario_3 ,
                                  :diccionario_4 ,
                                  :diccionario_5 ,
                                  :diccionario_6 ,
                                  :diccionario_7 ,
                                  :diccionario_8 ,
                                  :diccionario_9 ,
                                  :diccionario_10 ,
                                  :romana   ,
                                  :unidad  ,
                                  :c ) ";

        $dbh = $this->db->prepare($sql);
        $dbh->bindValue(':tipo', (empty($datos['tipo'])) ? ' ' : $datos['tipo'], PDO::PARAM_INT);
        $dbh->bindValue(':ref', (empty($datos['ref'])) ? ' ' : $datos['ref'], PDO::PARAM_STR);
        $dbh->bindValue(':label', (empty($datos['label'])) ? ' ' : $datos['label'], PDO::PARAM_STR);
        $dbh->bindValue(':tosell', (empty($datos['tosell'])) ? ' ' : $datos['tosell'], PDO::PARAM_INT);
        $dbh->bindValue(':tobuy', (empty($datos['tobuy'])) ? ' ' : $datos['tobuy'], PDO::PARAM_INT);
        $dbh->bindValue(':fk_user_autor', (empty($datos['fk_user_autor'])) ? ' ' : $datos['fk_user_autor'], PDO::PARAM_INT);

        $dbh->bindValue(':unidad', (empty($datos['unidad'])) ? ' ' : $datos['unidad'], PDO::PARAM_STR);

        $dbh->bindValue(':codigo_barras', (empty($datos['codigo_barras'])) ? '' : $datos['codigo_barras'], PDO::PARAM_STR);

        $dbh->bindValue(':stock_minimo_alerta', (empty($datos['stock_minimo_alerta'])) ? ' ' : $datos['stock_minimo_alerta'], PDO::PARAM_INT);

        //    $dbh->bindValue(':stock',(empty($datos['stock']))? ' ':$datos['stock'] ,PDO::PARAM_INT);

        $dbh->bindValue(':notas', (empty($datos['notas'])) ? ' ' : $datos['notas'], PDO::PARAM_STR);

        for ($i = 1; $i <= 10; $i++) {
            $dbh->bindValue(':diccionario_' . $i, (empty($datos['diccionario_' . $i])) ? 0 : $datos['diccionario_' . $i], PDO::PARAM_INT);
        }

        $dbh->bindValue(':romana', (empty($datos['romana'])) ? 0 : $datos['romana'], PDO::PARAM_INT);
        $dbh->bindValue(':descuento_maximo', (empty($datos['descuento_maximo'])) ? 0 : $datos['descuento_maximo'], PDO::PARAM_STR);





        $dbh->execute();
        // print_r($dbh->errorInfo());

        $id       = $this->db->lastInsertId();
        $this->id = $id;
        return $id;

    }

    public function update($datos)
    {

        global $_SESSION;

        $sql = "update  fi_productos

                                  set
                                  tipo  = :tipo,
                                  ref   = :ref,
                                  label = :label,
                                  codigo_barras = :codigo_barras,

                                   tosell = :tosell,
                                   tobuy  = :tobuy ,
                                   stock_minimo_alerta = :stock_minimo_alerta ,
                                   notas = :notas ,
                                   unidad  = :unidad  ,

                                   diccionario_1 = :diccionario_1 ,
                                   diccionario_2 = :diccionario_2 ,
                                   diccionario_3 = :diccionario_3 ,
                                   diccionario_4 = :diccionario_4 ,
                                   diccionario_5 = :diccionario_5 ,
                                   diccionario_6 = :diccionario_6 ,
                                   diccionario_7 = :diccionario_7 ,
                                   diccionario_8 = :diccionario_8 ,
                                   diccionario_9 = :diccionario_9 ,
                                   diccionario_10 = :diccionario_10 ,
                                   romana         = :romana ,
                                   descuento_maximo = :descuento_maximo
                                   

                                  WHERE    rowid = :rowid  and entidad = '" . $_SESSION['Entidad'] . "' ";

        $dbh = $this->db->prepare($sql);
        $dbh->bindValue(':tipo', (empty($datos['tipo'])) ? ' ' : $datos['tipo'], PDO::PARAM_INT);
        $dbh->bindValue(':ref', (empty($datos['ref'])) ? ' ' : $datos['ref'], PDO::PARAM_STR);
        $dbh->bindValue(':unidad', $datos['unidad'], PDO::PARAM_STR);

        $dbh->bindValue(':label', (empty($datos['label'])) ? ' ' : $datos['label'], PDO::PARAM_STR);
        $dbh->bindValue(':tosell', (empty($datos['tosell'])) ? ' ' : $datos['tosell'], PDO::PARAM_INT);
        $dbh->bindValue(':tobuy', (empty($datos['tobuy'])) ? ' ' : $datos['tobuy'], PDO::PARAM_INT);
        $dbh->bindValue(':notas', (empty($datos['notas'])) ? ' ' : $datos['notas'], PDO::PARAM_STR);
        $dbh->bindValue(':codigo_barras', (empty($datos['codigo_barras'])) ? '' : $datos['codigo_barras'], PDO::PARAM_STR);
        $dbh->bindValue(':romana', $datos['romana'], PDO::PARAM_INT);

        $dbh->bindValue(':stock_minimo_alerta', (empty($datos['stock_minimo_alerta'])) ? ' ' : $datos['stock_minimo_alerta'], PDO::PARAM_INT);

        for ($i = 1; $i <= 10; $i++) {
            $dbh->bindValue(':diccionario_' . $i, (empty($datos['diccionario_' . $i])) ? 0 : $datos['diccionario_' . $i], PDO::PARAM_INT);
        }

        $dbh->bindValue(':rowid', $datos['fiche'], PDO::PARAM_INT);
        $dbh->bindValue(':descuento_maximo', (empty($datos['descuento_maximo'])) ? 0 : $datos['descuento_maximo'], PDO::PARAM_STR);

        $dbh->execute();

        $this->id = $id;
        return $id;

    }

    public function fetch($id)
    {

        $sql = "select * from fi_productos  where rowid = :rowid ";
        $dbh = $this->db->prepare($sql);
        $dbh->bindValue(':rowid', $id, PDO::PARAM_INT);
        $dbh->execute();
        $datos      = $dbh->fetch(PDO::FETCH_ASSOC);
        $this->tipo = $datos['tipo'];
        $this->ref  = $datos['ref'];

        $this->fk_bodega_base = $datos['fk_bodega_base'];
        $this->romana         = $datos['romana'];
        $this->cbproveedor    = $datos['cbproveedor'];
        $this->cbinterno      = $datos['cbinterno'];

        $this->tosell              = $datos['tosell'];
        $this->tobuy               = $datos['tobuy'];
        $this->fk_user_autor       = $datos['fk_user_autor'];
        $this->stock               = $datos['stock'];
        $this->stock_minimo_alerta = $datos['stock_minimo_alerta'];
        $this->label               = $datos['label'];
        $this->notas               = $datos['notas'];
        $this->id                  = $datos['rowid'];
        $this->entidad             = $datos['entidad'];
        $this->unidad              = $datos['unidad'];


        $this->descuento_maximo              = $datos['descuento_maximo'];
        
        
        
        

        $this->codigo_barras = $datos['codigo_barras'];

        $this->conversion_venta         = $datos['conversion_venta'];
        $this->conversion_venta_numero  = $datos['conversion_venta_numero'];
        $this->conversion_compra        = $datos['conversion_compra'];
        $this->conversion_compra_numero = $datos['conversion_compra_numero'];

        $this->diccionario_1  = $datos['diccionario_1'];
        $this->diccionario_2  = $datos['diccionario_2'];
        $this->diccionario_3  = $datos['diccionario_3'];
        $this->diccionario_4  = $datos['diccionario_4'];
        $this->diccionario_5  = $datos['diccionario_5'];
        $this->diccionario_6  = $datos['diccionario_6'];
        $this->diccionario_7  = $datos['diccionario_7'];
        $this->diccionario_8  = $datos['diccionario_8'];
        $this->diccionario_9  = $datos['diccionario_9'];
        $this->diccionario_10 = $datos['diccionario_10'];
        $this->fk_bodega_base = $datos['fk_bodega_base'];

        if ($this->tipo == 1) {$this->tipo_texto = "Producto";} else if ($this->tipo == 2) {$this->tipo_texto = "Servicio";} else { $this->tipo_texto = "No Catalogado*";}

        // MEjoras CABYS 10 Octubre 2020
        $this->CABYS_codigo      = $datos['CABYS_codigo'];
        $this->CABYS_impuesto    = $datos['CABYS_impuesto'];
        $this->CABYS_descripcion = $datos['CABYS_descripcion'];
        $this->CABYS_listo       = $datos['CABYS_listo'];

    }

    public function borrar($id)
    {
        $sql = "delete from fi_terceros where md5(rowid) = :rowid ";
        $dbh = $this->db->prepare($sql);
        $dbh->bindValue(':rowid', $id, PDO::PARAM_STR);
        $dbh->execute();
    }

    /*

    Cambios CABYS 2020
    Octubre 2020
    dbermejo@avancescr.com

     */

    public function SetCABYS()
    {

        global $_SESSION;

        $sql = "update  fi_productos

                                  set
                                  CABYS_listo       =   1                   ,
                                  CABYS_codigo      =   :CABYS_codigo       ,
                                  CABYS_impuesto    =   :CABYS_impuesto     ,
                                  CABYS_descripcion =   :CABYS_descripcion  ,
                                  CABYS_FECHA       =   NOW()

                                  WHERE    rowid = :rowid  and entidad = '" . $_SESSION['Entidad'] . "' ";

        $dbh = $this->db->prepare($sql);

        $dbh->bindValue(':CABYS_codigo', $this->CABYS_codigo, PDO::PARAM_STR);
        $dbh->bindValue(':CABYS_impuesto', $this->CABYS_impuesto, PDO::PARAM_STR);
        $dbh->bindValue(':CABYS_descripcion', $this->CABYS_descripcion, PDO::PARAM_STR);
        $dbh->bindValue(':rowid', $this->id, PDO::PARAM_INT);
        $a = $dbh->execute();

        return $a;

    }

    public function venta()
    {

        $sql = "select * from fi_productos_precios_clientes   where fk_producto  = :rowid  order by rowid DESC  limit  1 ";
        $dbh = $this->db->prepare($sql);
        $dbh->bindValue(':rowid', $this->id, PDO::PARAM_INT);
        $dbh->execute();
        $a              = $datos              = $dbh->fetch(PDO::FETCH_ASSOC);
        $this->impuesto = $datos['impuesto'];
        $this->subtotal = $datos['subtotal'];
        $this->total    = $datos['total'];

        return $a;
    }

    public function actualizar_precio_venta()
    {

        $sql = " insert
                                        into

                                        fi_productos_precios_clientes
                                        (
                                        fk_producto
                                    ,   fk_usuario
                                    ,   impuesto
                                    ,   subtotal
                                    ,   total
                                    ,   moneda
                                    ,   fecha
                                        )
                                        values
                                        (

                                        :fk_producto
                                    ,   :fk_usuario
                                    ,   :impuesto
                                    ,   :subtotal
                                    ,   :total
                                    ,   1
                                    ,   NOW()
                                        )

                                        ";

        $dbh = $this->db->prepare($sql);
        $dbh->bindValue(':fk_producto', $this->id, PDO::PARAM_INT);
        $dbh->bindValue(':fk_usuario', $_SESSION['usuario'], PDO::PARAM_INT);
        $dbh->bindValue(':impuesto', $this->impuesto, PDO::PARAM_INT);
        $dbh->bindValue(':subtotal', $this->subtotal, PDO::PARAM_INT);
        $dbh->bindValue(':total', $this->total, PDO::PARAM_INT);
        $a = $dbh->execute();

        // print_r($dbh->errorInfo());
        // print_r($this->db->errorInfo());

        return $a;

    }
    // ALEXIS SANCHEZ 23-11-20
    // FUNCTION GET INFO PRODUCT BY CABYS CODE
    public function getProductByCabysCode($code)
    {
      global $_SESSION;
      $sql = "SELECT rowid FROM fi_productos WHERE entidad =:entidad AND CABYS_codigo =:CABYS_codigo LIMIT 1;";
      $dbh = $this->db->prepare($sql);
      $dbh->bindValue(':entidad',       $_SESSION['Entidad'], PDO::PARAM_INT);
      $dbh->bindValue(':CABYS_codigo',  $code,                PDO::PARAM_STR);
      $result = $dbh->execute();      
      $data   = $dbh->fetch(PDO::FETCH_ASSOC);
      $rowid  = (!empty($data['rowid']))? $data['rowid']: null;      
      // RETURN
      return $rowid;
    }
    // ALEXIS SANCHEZ 24-11-20
    // FUNCTION GET CONNECTION LICENSES
    public function getConnLicenses(){
      $conn = new PDO('mysql:host=localhost;dbname=facturac_Licencias;charset=UTF8', 'facturac_Licenci','Np!z}MPksQQw',array(
        PDO::ATTR_PERSISTENT => true ));
      // RETURN
      return $conn;
    }
    // ALEXIS SANCHEZ 24-11-20
    // FUNCTION GET INFO CABYS BY CODE
    public function getInfoCabysDetailByCode($code, $view_tax = true){
      $html = '';  
      $tr   = '';  
      $conn = $this->getConnLicenses();
      $sql  = 
        "SELECT cod_cab, des_cab, por_imp, cod_cat_001,des_cat_001,cod_cat_002,des_cat_002,cod_cat_003,des_cat_003,cod_cat_004,des_cat_004,
      cod_cat_005,des_cat_005,cod_cat_006,des_cat_006,cod_cat_007,des_cat_007,cod_cat_008,des_cat_008,
      des_cab,por_imp FROM es00cabys WHERE cod_cab =:code LIMIT 1;";
      $db   = $conn->prepare($sql);
      $db->bindValue(":code", $code, PDO::PARAM_STR);
      $db->execute();
      $data = $db->fetch(PDO::FETCH_OBJ);
      // VALID INFO
      if (($data) != ''):
        $tr .=
        '<tr>
          <th class="text-center">C&oacute;digo</th>';
        $tr .= ($view_tax)? '<th class="text-center">I.V.A</th>': '';
        $tr .='
        </tr> 
        <tr>
            <td class="text-center" style="color:#f06725;font-family:Helvetica;">'.$data->cod_cab.'</td>';
        $tr .= ($view_tax)? '<td class="text-center" style="color:#f06725;font-family:Helvetica;">'.number_format($data->por_imp,2,".",",").' %</td>': '';
        $tr .='            
          </tr>
          <tr><td class="text-center">'.$data->des_cab.'</td></tr>
          <tr>
            <th class="text-center" style="color:#f06725;font-family:Helvetica;">Nivel</th>
            <th class="text-center" style="color:#f06725;font-family:Helvetica;">Descripci&oacute;n</th>
          </tr>
          <tr><td class="text-center">'.$data->cod_cat_001.'</td><td class="text-left">'.$data->des_cat_001.'</td></tr>
          <tr><td class="text-center">'.$data->cod_cat_002.'</td><td class="text-left">'.$data->des_cat_002.'</td></tr>
          <tr><td class="text-center">'.$data->cod_cat_003.'</td><td class="text-left">'.$data->des_cat_003.'</td></tr>
          <tr><td class="text-center">'.$data->cod_cat_004.'</td><td class="text-left">'.$data->des_cat_004.'</td></tr>
          <tr><td class="text-center">'.$data->cod_cat_005.'</td><td class="text-left">'.$data->des_cat_005.'</td></tr>
          <tr><td class="text-center">'.$data->cod_cat_006.'</td><td class="text-left">'.$data->des_cat_006.'</td></tr>
          <tr><td class="text-center">'.$data->cod_cat_007.'</td><td class="text-left">'.$data->des_cat_007.'</td></tr>
          <tr><td class="text-center">'.$data->cod_cat_008.'</td><td class="text-left">'.$data->des_cat_008.'</td></tr>
        ';
      endif;
      // HTML
      $html = 
      '<h5 style="color:#f06725;">
        <div class="tooltip" style="opacity:1!important; cursor:pointer; "> <i class="fa fa-cube" aria-hidden="true"></i>
          <span class="tooltiptext">
          <table style="min-width:500px;" border="1">
            <tbody>'.$tr.'</tbody>
          </table>
          </span>
        </div>
        CABYS: '.$code.'
      </h5>';
      // RETURN
      return $html;
    }
} // fin de la clase --