<?php


class Proyecto{

public $db;
public $nombre;
public $rowid;
public $fk_tipo;
public $identificacion;
public $telefono;
public $correo;
public $direccion;
public $activo;



public function __construct ($db){         
        $this->db=$db;
}



   public function cargar_selector($selected){  

$_SESSION['Entidad'] = 540;

            $sql = "select * from proyectos  where 1 and (entidad = ".$_SESSION['Entidad']." and  activo = 1 ) ";
    
            
            $db  = $this->db->prepare( $sql );
            $db->execute();

      
            
            while ( $gastos_primer_nivel = $db->fetch(PDO::FETCH_OBJ))
            {

var_dump($gastos_primer_nivel);

              $sel     = ($selected == $gastos_primer_nivel->rowid) ? "selected='selected' " : "";


               $resultado.= $this->cargar_selector_Otro_nivel( 
                    $gastos_primer_nivel->rowid 
                  , $gastos_primer_nivel->etiqueta   
                  , $selected );


            }


            return $resultado;
  }
  
  
  public function aplicarProyecto($fk_proyecto, $fk_documento, $tipo)
    {
  
        
        $sql="";
        $process = "Actualizar realacion proyecto documento";

        try{

            // QUERY
            $sql = "DELETE FROM proyecto_documento WHERE fk_documento = :fk_documento AND entidad = :entidad AND tipo = :tipo";
            $db  = $this->db->prepare($sql);
            $db->bindValue(":fk_documento", $fk_documento, PDO::PARAM_INT);
            $db->bindValue(":entidad",  540, PDO::PARAM_INT);
            $db->bindParam(':tipo', $tipo, PDO::PARAM_INT);
      
         $borrado =   $db->execute();
        
         
         
        if($fk_proyecto > 0){
    
            //ahora si insertamos
            $sql = "INSERT INTO proyecto_documento SET fk_documento = :fk_documento, fk_proyecto = :fk_proyecto, entidad = :entidad, tipo = :tipo";
            $db  = $this->db->prepare($sql);
      
            $db->bindValue(":fk_documento", $fk_documento, PDO::PARAM_INT);
            $db->bindValue(":fk_proyecto",  $fk_proyecto, PDO::PARAM_INT);
            $db->bindValue(":entidad",  540, PDO::PARAM_INT);
            $db->bindValue(":tipo",  $tipo, PDO::PARAM_INT);
            
            
            $result = $db->execute();
        }
    
 

            // RETURN
            return 1;

        }catch(PDOException $e){
return $e;
       
         
        }
    }
    
    
       public function guardarProyecto($obj)
    {
      
        
        $sql="";
        $process = "Guardar el Registro de proyectos";

        try{

            // QUERY
            $sql = "INSERT INTO proyectos SET etiqueta = :etiqueta,
            descripcion = :descripcion,
            fecha_inicio = :fecha_inicio,
            fecha_fin = :fecha_fin,
            monto = :monto,
            moneda = :moneda,
            latitud = :latitud, 
            longitud = :longitud,
            entidad = :entidad,
            fk_usuario_creador = :fk_usuario_creador,
            creado_fecha = now()";
            $db  = $this->db->prepare($sql);
        
            
            $db->bindParam(':etiqueta', $obj->etiqueta);
            $db->bindParam(':descripcion', $obj->descripcion);
            $db->bindParam(':fecha_inicio', $obj->fecha_inicio);
            $db->bindParam(':fecha_fin', $obj->fecha_fin);
            $db->bindParam(':monto', $obj->monto);
            $db->bindParam(':moneda', $obj->moneda);
            $db->bindParam(':latitud', $obj->latitud);
            $db->bindParam(':longitud', $obj->longitud);
            $db->bindParam(':entidad', $_SESSION['Entidad']);
            $db->bindParam(':fk_usuario_creador', $_SESSION['usuario']);
            
            
            $result = $db->execute();



            // RETURN
            return 1;

        }catch(PDOException $e){
   return $e;

        }
    }


    public function actualizarProyecto($obj)
    {
      
        
        $sql="";
        $process = "Actualizar del Estado en el Registro de proyectos";

        try{

            // QUERY
            $sql = "UPDATE proyectos SET etiqueta = :etiqueta,
            descripcion = :descripcion,
            fecha_inicio = :fecha_inicio,
            fecha_fin = :fecha_fin,
            monto = :monto,
            moneda = :moneda,
            latitud = :latitud, 
            longitud = :longitud 
            WHERE rowid = :rowid;";
            $db  = $this->db->prepare($sql);
            $db->bindValue(":rowid", $obj->rowid, PDO::PARAM_INT);
            
            $db->bindParam(':etiqueta', $obj->etiqueta);
            $db->bindParam(':descripcion', $obj->descripcion);
            $db->bindParam(':fecha_inicio', $obj->fecha_inicio);
            $db->bindParam(':fecha_fin', $obj->fecha_fin);
            $db->bindParam(':monto', $obj->monto);
            $db->bindParam(':moneda', $obj->moneda);
            $db->bindParam(':latitud', $obj->latitud);
            $db->bindParam(':longitud', $obj->longitud);
            
            
            $result = $db->execute();


            //$this->log_success($this->file,$record,$process,$detail);

            // RETURN
            return 1;

        }catch(PDOException $e){

            return $e;
        }
    }


 // FUNCTION CAMBIAR STATUS del proyecto
    public function borrarProyecto($rowid)
    {
      
        
        $sql="";
        $process = "Actualizar del Estado en el Registro de proyectos";

        try{

            // QUERY
            $sql = "UPDATE proyectos SET borrado = 1 WHERE rowid = :rowid;";
            $db  = $this->db->prepare($sql);
            $db->bindValue(":rowid", $rowid, PDO::PARAM_INT);
            $result = $db->execute();

            //$this->log_success($this->file,$record,$process,$detail);

            // RETURN
            return 1;

        }catch(PDOException $e){

    return $e;
        }
    }


   public function obtenerSumaProyecto($fk_proyecto, $tipo)
    {
      
        
        $sql="";
        $process = "Obtener presupuesto utilizado para un proyecto segun el tipo";

        try{
//obtener documentos para este proyecto

            $sql = "SELECT * FROM proyecto_documento where fk_proyecto = :fk_proyecto AND tipo = :tipo";
            $db  = $this->db->prepare($sql);
            $db->bindValue(":fk_proyecto", $fk_proyecto, PDO::PARAM_INT);
            $db->bindValue(":tipo", $tipo, PDO::PARAM_INT);
            $result = $db->execute();
            $data =  $db->fetchAll(PDO::FETCH_OBJ);

          //consultar y sumar los montos de estas facturas segun el tipo
          $total_utilizado = 0;
          
          switch ($tipo) {
            //documentos
            case 1:
                foreach ($data as $item) {
                    $sql = "SELECT * FROM documentos_recibidos where rowid = :rowid";
                    $db  = $this->db->prepare($sql);
                    $db->bindValue(":rowid", $item->fk_documento, PDO::PARAM_INT);
                    $db->execute();
                  $documento =  $db->fetch(PDO::FETCH_OBJ);
              
                  $total_utilizado += $documento->MontoTotalImpuestoAcreditar;
                  }
                break;

                //gastos
                case 2:
                    foreach ($data as $item) {
                        $sql = "SELECT * FROM fi_gastos where rowid = :rowid";
                        $db  = $this->db->prepare($sql);
                        $db->bindValue(":rowid", $item->fk_documento, PDO::PARAM_INT);
                        $db->execute();
                      $documento =  $db->fetch(PDO::FETCH_OBJ);
                  
                      $total_utilizado += $documento->valor;
                      }
                    break;

                   // compras simplificadas
                    case 3:
                        foreach ($data as $item) {
                            $sql = "SELECT * FROM fi_simplificadas where rowid = :rowid";
                            $db  = $this->db->prepare($sql);
                            $db->bindValue(":rowid", $item->fk_documento, PDO::PARAM_INT);
                            $db->execute();
                          $documento =  $db->fetch(PDO::FETCH_OBJ);
                      
                          $total_utilizado += $documento->total;
                          }
                        break;
            
         
          }
        
            // RETURN
            return $total_utilizado;

        }catch(PDOException $e){

            //$this->sql_LogErrores($this->file, $sql,clear_string($e->getMessage()), $process);
            return $e;
        }
    }
    
    
   public function contarDias($fechaInicio, $fechaFin)
{
  $fechaInicio = new DateTime($fechaInicio);
  $fechaFin = new DateTime($fechaFin);

  $intervalo = $fechaInicio->diff($fechaFin);
  return $intervalo->days;
}

public function calcularPorcentajeDiasRestantes($totalDias, $diaActual)
{
  $diasRestantes = $totalDias - $diaActual;

  $porcentajeRestante = ($diasRestantes / $totalDias) * 100;

  return round($porcentajeRestante, 2);
}
    
      public function fetch($fk_proyecto, $entidad)
    {
      
        
        $sql="";
        $process = "Obtener presupuesto utilizado para un proyecto";

        try{
//obtener datos para este proyecto

            $sql = "SELECT * FROM proyectos where rowid = :fk_proyecto AND entidad = :entidad";
           
            $db  = $this->db->prepare($sql);
            $db->bindValue(":fk_proyecto", $fk_proyecto, PDO::PARAM_INT);
            $db->bindValue(":entidad", $entidad, PDO::PARAM_INT);
            $result = $db->execute();
          $data =  $db->fetch(PDO::FETCH_ASSOC);

    
            // RETURN
            return $data;

        }catch(PDOException $e){

            return $e;
        }
    }
  
  
    public function calcularPresupuesto($fk_proyecto)
    {
      
        
        $sql="";
        $process = "Obtener presupuesto utilizado para un proyecto";

        try{
//obtener documentos para este proyecto

            $sql = "SELECT * FROM proyecto_documento where fk_proyecto = :fk_proyecto";
            $db  = $this->db->prepare($sql);
            $db->bindValue(":fk_proyecto", $fk_proyecto, PDO::PARAM_INT);
            $result = $db->execute();
          $data =  $db->fetchAll(PDO::FETCH_OBJ);

          //consultar y sumar los montos de estas facturas
          $total_utilizado = 0;
          foreach ($data as $item) {
            $sql = "SELECT * FROM documentos_recibidos where rowid = :rowid";
            $db  = $this->db->prepare($sql);
            $db->bindValue(":rowid", $item->fk_documento, PDO::PARAM_INT);
            $db->execute();
          $documento =  $db->fetch(PDO::FETCH_OBJ);
      
          $total_utilizado += $documento->MontoTotalImpuestoAcreditar;
          }
          
       

            // RETURN
            return $total_utilizado;

        }catch(PDOException $e){

            return $e;
        }
    }




 // FUNCTION CAMBIAR STATUS del proyecto
    public function changeStatus($status)
    {
        $sql="";
        $process = "actualizar del Estado en el Registro de proyectos";

        try{

            // QUERY
            $sql = "UPDATE proyectos SET activo =:activo WHERE rowid =:rowid;";
            $db  = $this->db->prepare($sql);
            $db->bindValue(":rowid", $this->rowid, PDO::PARAM_INT);
            $db->bindValue(":activo", $status, PDO::PARAM_INT);
            $result = $db->execute();

 
            // RETURN
            return 1;

        }catch(PDOException $e){
    return $e;
            //$this->sql_LogErrores($this->file, $sql,clear_string($e->getMessage()), $process);
        
        }
    }


} //FIN DE LA CLASE


?>
