<?php

require(ENLACE_SERVIDOR . "mod_proyectos/object/proyectos.object.php");

$obj = new Proyecto($dbh);

$datos_proyecto = $obj->fetch($_GET['perfil'], $_SESSION['Entidad']);

if($_GET['perfil'] > 0 && empty($datos_proyecto)){
    echo acceso_invalido();
   exit(1);
}

$datos_presupuesto = $obj->calcularPresupuesto($_GET['perfil']);
$datos = $datos_proyecto;
$latitud = $datos['latitud'];
$longitud = $datos['longitud'];

if ($datos['moneda'] == 2) {

  $dolares_selected = 'selected';
  $colones_selected = '';
} else {

  $colones_selected = 'selected';
  $dolares_selected = '';
}

if ($latitud == '') {
  $latitud = 9.9281;
  $longitud = -84.0907;
}

if ($datos['moneda'] == 1) {
  $moneda_txt = 'USD';
} else {
  $moneda_txt = 'COLONES';
}

//obtenmos sumatoria documentos
$suma_documentos = $obj->obtenerSumaProyecto($_GET['perfil'], 1);

//obtenmos sumatoria gastos
$suma_gastos = $obj->obtenerSumaProyecto($_GET['perfil'], 2);

//obtenmos sumatoria compra simplificada 
$suma_compras = $obj->obtenerSumaProyecto($_GET['perfil'], 3);

$sobrante = $datos['monto'] - ($suma_documentos + $suma_gastos + $suma_compras);

//diferencia dias entre fecha inicio y fecha fin

$diferencia_fechas = $obj->contarDias($datos['fecha_inicio'], $datos['fecha_fin']);

$diferencia_fechas_hoy = $obj->contarDias(date('Y-m-d'), $datos['fecha_fin']);

$restante =  $obj->calcularPorcentajeDiasRestantes($diferencia_fechas, $diferencia_fechas_hoy);


$fk_proyecto_id = $_GET['perfil'];
?>

<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>

<link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />
<link rel="stylesheet" href="https://unpkg.com/leaflet-control-geocoder/dist/Control.Geocoder.css" />
<script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>
<script src="https://unpkg.com/leaflet-control-geocoder/dist/Control.Geocoder.js"></script>

<section class="content-header">
  <h1>
    Proyectos
    <small><?php if (empty($_GET['perfil'])) {
              echo "Creación Nuevo proyecto";
            } else {
              echo "Edici&oacute;n de proyecto";
            } ?></small>
  </h1>
  <ol class="breadcrumb">
    <li><a href="dashboard.php"><i class="fa fa-dashboard"></i> Inicio</a></li>
    <li><a href="#">Proyecto </a></li>
    <li class="active">Edici&oacute;n</li>
  </ol>
</section>

<style>
  div#chart_div {
    margin-left: 24%;
  }
</style>

<section class="content">
  <div class="row">
    <!-- left column -->
    <div class="col-md-6">
      <!-- general form elements -->
      <div class="box box-primary">
        <div class="box-header">
          <label for="ubicacion">Datos del proyecto</label>
        </div><!-- /.box-header -->
        <!-- form start -->
        <form role="form" method="POST" action="">

          <input type="hidden" value="true" name="formulario" />


          <div class="box-body">

            <table class="table table-bordered">

              <tr>
                <td><i class="fa fa-tag" aria-hidden="true"></i> Nombre proyecto </td>
                <td>
                  <?php if (!empty($error_valor)) {
                    echo  "<i class=\"fa fa-fw fa-warning\"></i> $error_valor ";
                  } ?>
                  <input placeholder='Escriba el nombre del proyecto' id='etiqueta' name="etiqueta" type="text" class="form-control" value="<?php echo ($datos['etiqueta']); ?>" <?php echo (!empty($datos['rowid'])) ? '' : ''; ?>>
                </td>
              </tr>

              <tr>
                <td><i class="fa fa-align-justify" aria-hidden="true"></i> Descripcion del proyecto </td>
                <td>
                  <?php if (!empty($error_valor)) {
                    echo  "<i class=\"fa fa-fw fa-warning\"></i> $error_valor ";
                  } ?>
                  <textarea placeholder='Escriba una descripcion' name="descripcion" id="descripcion" class="form-control" <?php echo (!empty($datos['descripcion'])) ? '' : ''; ?>><?php echo ($datos['descripcion']); ?></textarea>
                </td>
              </tr>

              <tr>
                <td><i class="fa fa-calendar" aria-hidden="true"></i> Fecha inicio </td>
                <td>
                  <?php if (!empty($error_valor)) {
                    echo  "<i class=\"fa fa-fw fa-warning\"></i> $error_valor ";
                  } ?>
                  <input id="fecha_inicio" name="fecha_inicio" type="date" class="form-control" value="<?php echo ($datos['fecha_inicio']); ?>" <?php echo (!empty($datos['fecha_inicio'])) ? '' : ''; ?>>
                </td>
              </tr>

              <tr>
                <td><i class="fa fa-calendar" aria-hidden="true"></i> Fecha Fin </td>
                <td>
                  <?php if (!empty($error_valor)) {
                    echo  "<i class=\"fa fa-fw fa-warning\"></i> $error_valor ";
                  } ?>
                  <input name="fecha_fin" id="fecha_fin" type="date" class="form-control" value="<?php echo ($datos['fecha_fin']); ?>" <?php echo (!empty($datos['fecha_fin'])) ? '' : ''; ?>>
                </td>
              </tr>



              <tr>
                <td><i class="fa fa-tag" aria-hidden="true"></i> Presupuesto </td>
                <td>
                  <?php if (!empty($error_valor)) {
                    echo  "<i class=\"fa fa-fw fa-warning\"></i> $error_valor ";
                  } ?>
                  <input placeholder='Escriba el monto del proyecto' name="monto" id="monto" type="text" class="form-control" value="<?php echo ($datos['monto']); ?>" <?php echo (!empty($datos['monto'])) ? '' : ''; ?>>
                </td>
              </tr>


              <tr>
                <td><i class="fa fa-money" aria-hidden="true"></i> Moneda </td>
                <td>
                  <?php if (!empty($error_valor)) {
                    echo  "<i class=\"fa fa-fw fa-warning\"></i> $error_valor ";
                  } ?>

                  <select name='moneda' id='moneda' class='form-control'>


                    <option <?= $colones_selected ?> value='1'>Colones</option>
                    <option <?= $dolares_selected ?> value='2'>Dolares</option>
                  </select>

                </td>
              </tr>

              <tr>
                <td> </td>
                <td>
                  <?php if (!empty($error_valor)) {
                    echo  "<i class=\"fa fa-fw fa-warning\"></i> $error_valor ";
                  } ?>
                  <input id='latitud' name="latitud" type="hidden" class="form-control" value="<?= $latitud ?>">
                  <br>
                  <input id='longitud' name="longitud" type="hidden" class="form-control" value="<?= $longitud ?>">

                </td>
              </tr>

            </table>


          </div>


          <!-- /.box-body -->

          <div class="box-footer">


            <a href="<?php ENLACE_WEB; ?>dashboard.php?accion=proyectos_listado" class="btn btn-danger">Volver atras</a>
            <?php

            if ($_GET['perfil'] > 0) {
            ?>
              <button type="button" onclick='actualizarProyecto(<?= $_GET['perfil'] ?>)' class="btn btn-primary"><i class="fa fa-floppy-o" aria-hidden="true"></i> Actualizar</button>

            <?php } else {
            ?>
          
                  <button id='btn_guardar' type="button" onclick='actualizarProyecto(0)' class="btn btn-primary"><i class="fa fa-floppy-o" aria-hidden="true"></i> Guardar</button>

            <?php
            }
            ?>


          </div>
        </form>
      </div><!-- /.box -->




    </div><!--/.col (left) -->


    <div class='col-md-6'>
      <div class="box box-primary">
        <div class='box-body'>


          <div class="form-group">
            <label for="ubicacion"><i class="fa fa-globe" aria-hidden="true"></i> UBICACION DEL PROYECTO</label>
            <div id="mapid" style="width: 100%; height: 500px;">


            </div>
          </div>

        </div>
      </div>

    </div>


    <div class='col-md-8'>
      <div class="box box-primary">
        <div class='box-body'>


          <div class="form-group">
            <label for="ubicacion"><i class="fa fa-globe" aria-hidden="true"></i> LISTADO DE GASTOS</label>
<!--
            <div id="piechart_3d" style="min-height: 500px; height: 500px; max-height: 500px; max-width: 100%;"></div>
-->



     <table class="table table-hover" width="100%">
                
				            
                    <tbody id="tbody"> 
                                <?php   include_once(ENLACE_SERVIDOR."mod_gastos/ajax/listado_por_proyecto.php" ); ?>

                    </tbody>
                    </form>
                    
                    </table>




          </div>
        </div>

      </div>
    </div>



    <div class='col-md-4'>
      <div class="box box-primary">
        <div class='box-body'>


          <div class="form-group">
            <label for="ubicacion"><i class="fa fa-calendar" aria-hidden="true"></i> % TIEMPO RESTANTE DEL PROYECTO</label>
            <br>
            <small>Calculo entre la fecha de inicio/fin</small>
            <div class='text-center'>
              <div id="chart_div"></div>
            </div>







          </div>
        </div>

      </div>
    </div>

  </div>



  <!-- /.row -->
</section>

<script type="text/javascript">
  google.charts.load("current", {
    packages: ["corechart"]
  });
  google.charts.setOnLoadCallback(drawChart);

  function drawChart() {
    var data = google.visualization.arrayToDataTable([
      ['Task', 'Hours per Day'],
      ['Gastos', <?= $suma_gastos ?>],
      ['Documentos', <?= $suma_documentos ?>],
      ['Compras simplificadas', <?= $suma_compras ?>],
      ['Sobrante', <?= $sobrante ?>],

    ]);

    var options = {
      title: 'Presupuesto de <?= $datos['monto'] . ' ' . $moneda_txt ?>',
      pieHole: 0.4,
    };

    var chart = new google.visualization.PieChart(document.getElementById('piechart_3d'));
    chart.draw(data, options);
  }
</script>



<script>
  var mymap = L.map('mapid').setView([$("#latitud").val(), $("#longitud").val()], 10); // San José, Costa Rica

  L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
    maxZoom: 19,
  }).addTo(mymap);

  var marker = L.marker([$("#latitud").val(), $("#longitud").val()], {
    draggable: 'true'
  }).addTo(mymap);

  marker.on('dragend', function(event) {
    var position = marker.getLatLng();
    console.log(position);
    //actualizmos la ubicacion en el form
    $("#latitud").val(position.lat);
    $("#longitud").val(position.lng);

  });

  L.Control.geocoder({
      defaultMarkGeocode: false,
      geocoder: L.Control.Geocoder.nominatim()
    })
    .on('markgeocode', function(e) {
      mymap.fitBounds(e.geocode.bbox);
      if (marker) {
        mymap.removeLayer(marker);
      }
      marker = L.marker(e.geocode.center, {
        draggable: 'true'
      }).addTo(mymap);
      marker.on('dragend', function(event) {
        var position = marker.getLatLng();
        console.log(position);
        //actualizamos la ubicacion en el form
        $("#latitud").val(position.lat);
        $("#longitud").val(position.lng);

      });
      console.log(e.geocode.center);
      $("#latitud").val(e.geocode.center.lat);
      $("#longitud").val(e.geocode.center.lng);
    })
    .addTo(mymap);
</script>






<!-- cargar la libreria para la donut chart script -->
<script src="<?= ENLACE_WEB ?>/assets/js/apexchart.min.js"></script>
<!-- Page specific script -->
<script>
  $(function() {

    var donutChartCanvas = $('#donutChart').get(0).getContext('2d')
    var donutData = {
      labels: [
        'Consumido',
        'Tiempo',
      ],
      datasets: [{
        data: [40, 60],
        backgroundColor: ['#f56954', '#00a65a', '#f39c12', '#3c8dbc'],
      }]
    }
    var donutOptions = {
      maintainAspectRatio: false,
      responsive: true,
    }
    //Create pie or douhnut chart
    // You can switch between pie and douhnut using the method below.
    new Chart(donutChartCanvas, {
      type: 'doughnut',
      data: donutData,
      options: donutOptions
    })
    var total = 100 - <?= $presupuesto_utilizado ?>;
    // Segundo gráfico con un id diferente y configuración diferente
    var donutChartCanvas2 = $('#donutChart2').get(0).getContext('2d')
    var donutData2 = {
      labels: [
        'Consumido',
        'Presupuesto restante',
      ],
      datasets: [{
        data: [<?= $presupuesto_utilizado ?>, total],
        backgroundColor: ['#f39c12', '#3c8dbc', '#f56954', '#00a65a'],
      }]
    }
    new Chart(donutChartCanvas2, {
      type: 'doughnut',
      data: donutData2,
      options: donutOptions
    })

  })
</script>


<script type="text/javascript">
  google.charts.load('current', {
    'packages': ['gauge']
  });
  google.charts.setOnLoadCallback(drawChart);

  function drawChart() {

    var data = google.visualization.arrayToDataTable([
      ['Label', 'Value'],
      ['Tiempo', <?= $restante ?>],


    ]);

    var options = {
      width: 400,
      height: 180,
      redFrom: 90,
      redTo: 100,
      yellowFrom: 75,
      yellowTo: 90,
      minorTicks: 5
    };

    var chart = new google.visualization.Gauge(document.getElementById('chart_div'));

    chart.draw(data, options);


  }
</script>


<script>
  function actualizarProyecto(rowid) {
         $("#etiqueta").removeClass('input_error');
         
if($("#etiqueta").val() == ''){
    
    $("#etiqueta").addClass('input_error');
    return false;
}

    $.ajax({
      method: "POST",
      url: "<?php echo ENLACE_WEB; ?>mod_proyectos/class/editar_proyecto.php",
      data: {
        action: 'actualizarProyecto',
        rowid: rowid,
        etiqueta: $("#etiqueta").val(),
        descripcion: $("#descripcion").val(),
        fecha_inicio: $("#fecha_inicio").val(),
        fecha_fin: $("#fecha_fin").val(),
        monto: $("#monto").val(),
        moneda: $("#moneda").val(),
        latitud: $("#latitud").val(),
        longitud: $("#longitud").val(),

      },
    }).done(function(resultado) {
      console.log(resultado);
      
      //ocultar el boton de guardar
      $("#btn_guardar").hide();

      if (resultado == 1) {
       $.toast({
          heading: 'Exito',
          text: 'Guardado correctamente',
          icon: 'success',
          position: 'top-right',
        })
      } else {
        $.toast({
          heading: 'Error',
          text: 'Se presento un error en modificación del estado del registro.',
          icon: 'error',
          position: 'top-right',
        })
      }


    });



  }
</script>