<?php
  SESSION_START();
  include_once("../../conf/conf.php");
  $rowid = (!empty($_POST['rowid']))? $_POST['rowid']: null;
  $cabys = (!empty($_POST['cabys']))? $_POST['cabys']: null;
?>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/dt/dt-1.10.22/datatables.min.css"/>
<script type="text/javascript" src="https://cdn.datatables.net/v/dt/dt-1.10.22/datatables.min.js"></script>
<!-- HTML -->
<div class="modal-content" style="width:700px;">
    <!-- HEADER -->
    <div class="modal-header">
      <h3 class="modal-title" style="color:#f06725;font-family:Helvetica;font-size:25px;">Listado de Productos</h3>
    </div>
    <!-- BODY -->
    <div class="modal-body">
        <div class="table-responsive">
            <table id="tableProducts" class="table table-striped" style="width:100%;">
                <thead>                        
                  <tr style="background-color:grey;color:white;">
                    <th class="text-center">#</th>
                    <th class="text-center">CABYS</th>
                    <th class="text-center">Nombre</th>
                  </tr>
                </thead>
                <tbody id="tbodyProducts"></tbody>
            </table>
            <!-- TABLE CABYS -->
            <table id="tableDetialsCabys" class="table table-striped" style="display:none;width:100%;">
                <thead>                        
                  <tr style="background-color:grey;color:white;">
                    <th class="text-center">CODIGO</th>
                    <th class="text-center">DESCRIPCION</th>
                    <th class="text-center">%I.V.A</th>
                    <th class="text-center"></th>
                  </tr>
                </thead>
                <tbody id="tbodyDetialsCabys"></tbody>
            </table>
            <!-- TABLE INFO -->
            <a id="por_cabys" style="display:none;color:#ff0000;font-family:Helvetica;font-size:20px;"></a><br>
            <a id="des_cabys" style="display:none;font-family:Helvetica;font-size:18px;"></a><br>
            <table id="tableInfoCabys" class="table table-striped" style="display:none;width:100%;">
                <thead>                        
                  <tr>
                    <th class="text-center" style="color:#f06725;font-family:Helvetica;font-size:18px;">Nivel</th>
                    <th class="text-center" style="color:#f06725;font-family:Helvetica;font-size:18px;">Descripción</th>
                  </tr>
                </thead>
                <tbody id="tbodyInfoCabys"></tbody>
            </table>
        </div>   
    </div>
    <!-- FOOTER -->
    <div class="modal-footer">
      <!-- LAST -->
     <!--  <button class="btn btn-success notika-btn-success waves-effect" id="btnLast" style="display:none;" onclick="viewOptionProducts()">Atrás</button> -->
      <!-- CONSULT -->
      <!-- <button class="btn btn-warning notika-btn-warning waves-effect" id="btnConsult" onclick="viewOptionConsultCabys()">Consulta CABYS</button> -->
      <!-- CONSULT -->
     <!--  <button class="btn btn-warning notika-btn-warning waves-effect" id="bntUse" style="display:none;" onclick="useCabysCode()">Uitlizar Códigp</button> -->
      <!-- SAVE -->
      <button class="btn btn-success notika-btn-success waves-effect" id="btnAdd" onclick="addCabysCodeProduct()">Asignar</button>
      <!-- CLOSE -->
      <button class="btn btn-danger notika-btn-danger waves-effect" id="btnClose" onclick="hideModalProducts()">Cerrar</button>
    </div>
</div>
<!-- SCRIPT -->
<script type="text/javascript">
  // OPTION READY WINDOW
  $(document).ready(function() {
    // FUNCTION LOAD INFO PRODUCTS
    loadInfoProducts();
  });
  // FUNCTION LOAD INFO PRODUCTS
  function loadInfoProducts(){
    $("#tbodyProducts").empty().html('<center style="margin-top:10%;width:15px;"><img src="<?php echo ENLACE_WEB; ?>images/salvando.gif" width="30px"></center>');
    // POST
    $.ajax({
        method: "POST",
        url: "<?php echo ENLACE_WEB; ?>mod_recepcion/class/clases.php",        
        beforeSend: function(xhr) { },
        data: 
        {  
            action : 'loadInfoProducts'
        },
    }).done(function(data) {          
        $("#tbodyProducts").html(data);    

        tableProducts = $('#tableProducts').DataTable({
          "pagingType": "full_numbers",
          "select": true,
          "ordering": false,
          "info":     false,
          "language": {
            "lengthMenu": "Mostrar _MENU_ registros",
            "zeroRecords": "No se encontraron resultados",
            "info": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
            "infoEmpty": "Mostrando registros del 0 al 0 de un total de 0 registros",
            "infoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
              "sFirst": "Primero",
              "sLast":"Último",
              "sNext":"Siguiente",                   
              "sPrevious": "Anterior"
            },
            "sProcessing":"Procesando...",
          }
        });

        $('#tableProducts tbody').on( 'click', 'tr', function () {
          // VALID SELECT
          if ($(this).hasClass('selected')) {
            $(this).removeClass('selected');
          } else {
            tableProducts.$('tr.selected').removeClass('selected');
            $(this).addClass('selected');
          }
        });
   
        $('#button').click( function () {
          tableProducts.row('.selected').remove().draw( false );
        });
        // SHOW TABLE
        $("#tableProducts").show();
    });
  }
  // FUNCTION ADD CABYS CODE TO PRODUCT
  function addCabysCodeProduct(){
    var file  = '<?php echo $rowid; ?>';
    var cabys = '<?php echo $cabys; ?>';
    // FUNCION GET PRODUCT SELECTED
    getProductSelected(function(data){
        // VALID DEFINITION PRODUCT
        if ((data.length) > 0){
          var product = data[0]['product'];
          var label   = data[0]['label'];
          // CONFIRM
          if (confirm('Está seguro(a) que desea asociar la información del código cabys "'+cabys+'" al producto "'+label+'"')){
            // POST
            $.ajax({
                method: "POST",
                url: "<?php echo ENLACE_WEB; ?>mod_recepcion/class/clases.php",        
                beforeSend: function(xhr) { },
                data: 
                {  
                    action  : 'addCabysCodeProduct',
                    cabys   : cabys,
                    product : product
                },
            }).done(function(data) { 
              data = JSON.parse(data);      
              // VALID RESULT
              switch(Number(data.result)) {
                  case 0:
                    $.notify("Se presento un error en proceso de asociación la información del código cabys al producto.", "warn");
                  break;
                  case 1:
                    $.notify("Proceso de asociación la información del código cabys al producto, realizado con éxito.","success");
                    location.href = "<?php echo ENLACE_WEB; ?>documento/"+file;
                  break;
                  case 2:
                    $.notify(data.message, "warn");
                  break;
              }
            });
          }
        } else {
          alert('Debe seleccionar la información del producto, para continuar.');
        }
    });
  }

  // FUNCION GET PRODUCT SELECTED
  function getProductSelected(callback){
    var product       = new Array();
    var arrayProduct  = [];
    // RUN RECORDS SERVICES
    $('#tbodyProducts tr').each(function() {
      // VALID SELECTED
      if ($(this).hasClass('selected')){  
        product = {
            "product"   : $(this).data('product'),
            "label"     : $(this).data('label')
        };
        arrayProduct.push(product);    
      }      
    });
    return callback(arrayProduct);
  }

  // FUNCION VIEW OPTION CONSULT CABYS
  function viewOptionConsultCabys(){ 
    $("#tableProducts").empty().html('');
    tableProducts.destroy();
    $("#tableProducts").hide();
    $("#btnAdd").hide();     
    $("#btnConsult").hide(); 
    $("#btnLast").show();
    $(".modal-title").text('Herramienta CABYS');
    $("#btnLast").attr('onclick', 'viewOptionProducts()');
    $("#tableInfoCabys").hide();
    $("#por_cabys").hide();
    $("#des_cabys").hide();
    $("#bntUse").hide();
    // FUNCTION LOAD INFO CABYS DETAILS
    loadInfoCabysDetails();    
  }  

  // FUNCION VIEW OPTION CONSULT CABYS
  function viewOptionProducts(){  
    $("#tableDetialsCabys").empty().html('');
    tableDetialsCabys.destroy();
    $("#tableDetialsCabys").hide();
    $("#btnAdd").show();     
    $("#btnConsult").show(); 
    $("#btnLast").hide();
    $(".modal-title").text('Listado de Productos');
    // FUNCTION LOAD INFO PRODUCTS
    loadInfoProducts();   
  }

  // FUNCTION LOAD INFO CABYS DETAILS
  function loadInfoCabysDetails(){
    $("#tbodyDetialsCabys").empty().html('<center style="margin-top:10%;><img src="<?php echo ENLACE_WEB; ?>images/salvando.gif" width="30px"></center>');
    // POST
    $.ajax({
        method: "POST",
        url: "<?php echo ENLACE_WEB; ?>mod_recepcion/class/clases.php",        
        beforeSend: function(xhr) { },
        data: 
        {  
            action : 'loadInfoCabysDetails'
        },
    }).done(function(data) {          
        $("#tbodyDetialsCabys").html(data);  

        tableDetialsCabys = $('#tableDetialsCabys').DataTable({
          "pagingType": "full_numbers",
          "select": true,
          "ordering": false,
          "info":     false,
          "language": {
            "lengthMenu": "Mostrar _MENU_ registros",
            "zeroRecords": "No se encontraron resultados",
            "info": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
            "infoEmpty": "Mostrando registros del 0 al 0 de un total de 0 registros",
            "infoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
              "sFirst": "Primero",
              "sLast":"Último",
              "sNext":"Siguiente",                   
              "sPrevious": "Anterior"
            },
            "sProcessing":"Procesando...",
          }
        });

        $('#tableDetialsCabys tbody').on( 'click', 'tr', function () {
          // VALID SELECT
          if ($(this).hasClass('selected')) {
            $(this).removeClass('selected');
          } else {
            tableDetialsCabys.$('tr.selected').removeClass('selected');
            $(this).addClass('selected');
          }
        });
   
        $('#button').click( function () {
          tableDetialsCabys.row('.selected').remove().draw( false );
        });
        // SHOW TABLE
        $("#tableDetialsCabys").show();
    });
  }   
  // FUNCTION VIEW DETAI CABYS
  function viewDetailCabys(code, tax, description){
    var tax = parseFloat(tax).toFixed(2);
    $("#tableProducts").empty().html('');
    $("#tableDetialsCabys").empty().html('');
    tableProducts.destroy(); 
    tableDetialsCabys.destroy();
    $(".modal-title").text(code);
    $("#por_cabys").text(tax+' %');
    $("#des_cabys").text(description);
    $("#tableProducts").hide();
    $("#tableDetialsCabys").hide();
    $("#por_cabys").show();
    $("#des_cabys").show();
    $("#bntUse").show();

    $("#btnLast").attr('onclick', 'viewOptionConsultCabys()');
    $("#tbodyInfoCabys").empty().html('<center style="margin-top:10%;><img src="<?php echo ENLACE_WEB; ?>images/salvando.gif" width="30px"></center>');
    // POST
    $.ajax({
        method: "POST",
        url: "<?php echo ENLACE_WEB; ?>mod_recepcion/class/clases.php",        
        beforeSend: function(xhr) { },
        data: 
        {  
            action  : 'loadInfoCabysByCode',
            code    : code
        },
    }).done(function(data) {          
        $("#tbodyInfoCabys").html(data);
        $("#tableInfoCabys").show();
    });
  }  
</script>