<?php
// VALID DEFINITIO ACTION
if (! empty($_POST['action'])):
  SESSION_START();
  include_once("../../conf/conf.php");
  // VALID ACTION
  switch($_POST['action']):
      case "loadInfoProducts":
        // FUNCTION LOAD INFO PRODUCTS
        loadInfoProducts($dbh);
      break; 
      case "loadInfoCabysDetails":
        // FUNCTION GET INFO CABYS DETAILS
        loadInfoCabysDetails($dbh);
      break; 
      case "loadInfoCabysByCode":
        // FUNCTION GET INFO CABYS BY CODE
        loadInfoCabysByCode($dbh, $_POST['code']);
      break; 
      case "addCabysCodeProduct":
        // FUNCTION ADD CABYS CODE PRODUCT
        addCabysCodeProduct($dbh, $_POST['cabys'], $_POST['product']);
      break;
  endswitch;
endif;


// FUNCTION GET CONNECTION LICENSES
function getConnLicenses(){
  $conn = new PDO('mysql:host=localhost;dbname=facturac_Licencias;charset=UTF8', 'facturac_Licenci','Np!z}MPksQQw',array(
    PDO::ATTR_PERSISTENT => true ));
  // RETURN
  return $conn;
}

// FUNCTION LOAD INFO PRODUCTS
function loadInfoProducts($dbh){
  $html = '';  
  $sql  = "SELECT * FROM fi_productos WHERE entidad =:entidad AND eliminado = 0 ORDER BY label;";
  $db   = $dbh->prepare($sql);
  $db->bindValue(":entidad", $_SESSION['Entidad'], PDO::PARAM_INT);
  $db->execute();
  $cont = 1;
  // RUN ATTACHMENT
  while ($data = $db->fetch(PDO::FETCH_OBJ)):
    $html .=
    '<tr data-product="'.$data->rowid.'" data-label="'.$data->label.'">
        <td class="text-center"><a class="ng-binding" style="color:black" href="#">'.$cont.'</a></td>
        <td class="text-center"><a class="ng-binding" style="color:black" href="#">'.$data->CABYS_codigo.'</a></td>
        <td class="text-left"><a class="ng-binding" style="color:black" href="#">'.$data->label.'</a></td>
    </tr>';
    $cont++;
  endwhile;
  // RETURN
  echo $html;
}

// FUNCTION GET INFO CABYS DETAILS
function loadInfoCabysDetails($dbh){
  $html = '';  
  $conn = getConnLicenses();
  $html = '';  
  $sql  = "SELECT cod_cab, des_cab, por_imp FROM es00cabys ORDER BY des_cab;";
  $db   = $conn->prepare($sql);
  $db->execute();
  // RUN ATTACHMENT
  while ($data = $db->fetch(PDO::FETCH_OBJ)):
    $html .=
    '<tr>
        <td class="text-center"><a class="ng-binding" style="color:black" href="#">'.$data->cod_cab.'</a></td>
        <td class="text-left"><a class="ng-binding" style="color:black" href="#">'.$data->des_cab.'</a></td>
        <td class="text-center"><a class="ng-binding" style="color:black" href="#">'.$data->por_imp.'</a></td>
        <td class="text-center"><button title="Detalle" type="button" class="btn btn-info bt_detalle " onclick="viewDetailCabys('.$data->cod_cab.','.$data->por_imp.',\''.clear_string_url($data->des_cab).'\')"><i class="fa fa-fw fa-circle-o"></i></button></td>
    </tr>';
  endwhile;
  // RETURN
  echo $html;
}

// FUNCTION GET INFO CABYS BY CODE
function loadInfoCabysByCode($dbh, $code){
  $html = '';  
  $conn = getConnLicenses();
  $html = '';  
  $sql  = 
    "SELECT cod_cat_001,des_cat_001,cod_cat_002,des_cat_002,cod_cat_003,des_cat_003,cod_cat_004,des_cat_004,
    cod_cat_005,des_cat_005,cod_cat_006,des_cat_006,cod_cat_007,des_cat_007,cod_cat_008,des_cat_008,
    des_cab,por_imp FROM es00cabys WHERE cod_cab =:code LIMIT 1;";
  $db   = $conn->prepare($sql);
  $db->bindValue(":code", $code, PDO::PARAM_STR);
  $db->execute();
  $data = $db->fetch(PDO::FETCH_OBJ);
  // VALID INFO
  if (($data) != ''):
    $html .=
    ' <tr><td class="text-left">'.$data->cod_cat_001.'</td><td class="text-left">'.$data->des_cat_001.'</td></tr>
      <tr><td class="text-left">'.$data->cod_cat_002.'</td><td class="text-left">'.$data->des_cat_002.'</td></tr>
      <tr><td class="text-left">'.$data->cod_cat_003.'</td><td class="text-left">'.$data->des_cat_003.'</td></tr>
      <tr><td class="text-left">'.$data->cod_cat_004.'</td><td class="text-left">'.$data->des_cat_004.'</td></tr>
      <tr><td class="text-left">'.$data->cod_cat_005.'</td><td class="text-left">'.$data->des_cat_005.'</td></tr>
      <tr><td class="text-left">'.$data->cod_cat_006.'</td><td class="text-left">'.$data->des_cat_006.'</td></tr>
      <tr><td class="text-left">'.$data->cod_cat_007.'</td><td class="text-left">'.$data->des_cat_007.'</td></tr>
      <tr><td class="text-left">'.$data->cod_cat_008.'</td><td class="text-left">'.$data->des_cat_008.'</td></tr>
    ';
  endif;
  // RETURN
  echo $html;

}

// FUNCTION GET INFO CABYS PRODUCTS
function getInfoCabysProduct($dbh, $cabys){
  $conn = getConnLicenses();
  $html = '';  
  $sql  = "SELECT * FROM es00cabys WHERE cod_cab =:cod_cab LIMIT 1;";
  $db   = $conn->prepare($sql);
  $db->bindValue(":cod_cab", $cabys, PDO::PARAM_STR);
  $db->execute();
  $data = $db->fetch(PDO::FETCH_OBJ);
  $data = (!empty($data))? $data: null;
  // RETURN
  return $data;
}

// FUNCTION ADD CABYS CODE PRODUCT        
function addCabysCodeProduct($dbh, $cabys, $product){
  $array = array();
  // FUNCTION GET INFO CABYS PRODUCTS
  $data = getInfoCabysProduct($dbh, $cabys);
  // VALID DATA
  if (!is_null($data)):
    SESSION_START();
    include_once("../../conf/conf.php");
    // QUERY 
    $sql =
      "UPDATE  fi_productos 
      SET
        CABYS_listo       =1                   ,
        CABYS_codigo      =:CABYS_codigo       ,
        CABYS_impuesto    =:CABYS_impuesto     ,
        CABYS_descripcion =:CABYS_descripcion  ,
        CABYS_FECHA       =NOW()
      WHERE  entidad      =:entidad 
      AND rowid           =:rowid;";
    $db = $dbh->prepare($sql);
    $db->bindValue(":CABYS_codigo",       $cabys,               PDO::PARAM_STR);  
    $db->bindValue(":CABYS_impuesto",     $data->por_imp,       PDO::PARAM_STR);
    $db->bindValue(":CABYS_descripcion",  $data->des_cab,       PDO::PARAM_STR);
    $db->bindValue(":entidad",            $_SESSION['Entidad'], PDO::PARAM_INT);
    $db->bindValue(":rowid",              $product,             PDO::PARAM_INT);
    $result = $db->execute();
    $array  = array('result' => $result, 'message' => '');
  else:
    $array  = array('result' => 2, 'message' => 'La informacin del cdigo cabys, no se encuentra defina en el catlogo de cdigos cabys.');
  endif;
  // RETURN
  echo json_encode($array);
}
?>