<?php
require_once ENLACE_SERVIDOR . "global/object/log.sistema.php";
require_once ENLACE_SERVIDOR . "mod_sendgrid/EnviarCorreoSendgrid.php";

class email extends log_sistema
{

    private $db;
    public $fk_empresa;
    public $fk_usuario;


    public function __construct($db)
    {
        $this->db = $db;
        parent::__construct($db);
        $this->file = basename(__FILE__);
    }

    public function verificarEmail($email)
    {

        try {


            $sql = "SELECT email,token, rowid  FROM fi_usuarios WHERE email=:email and activo=1 ";
            $db  = $this->db->prepare($sql);
            $db->bindValue(':email', $email, PDO::PARAM_STR);
            $db->execute();
            $data = $db->fetch(PDO::FETCH_ASSOC);

            if ($data['rowid'] > 0) {

                //Generar expiracion y token
                $newToken = $this->generarTokenExpiracion($email);

                $url = ENLACE_WEB . 'email_reset?email=' . $data['email'] . '&token=' . $newToken . '';
                //Informacion Sendgrip
                $apiSendgrip = $this->obtenerApiSendgrip();
                $emailRemitente = $apiSendgrip['correo'];
                $nombreRemitente = $apiSendgrip['correo_nombre'];
                $host = $apiSendgrip['host'];
                $hash = $apiSendgrip['hash'];
                //Enviar Email
                $respuestaEmail = Email_Sendgrid(
                    "Notificación RQ",
                    $this->body($url),
                    $data['email'],
                    null,
                    null,
                    $emailRemitente,
                    $nombreRemitente,
                    $host,
                    $hash
                );

                //Guardamos el Email log
                $resemail = $this->guardarEmail($data['email'], $respuestaEmail['codigo'], $respuestaEmail['id_mensaje']);
                //return $resemail;
                $array = array("error" => 0, "url" => $url, "id_message" => $respuestaEmail['id_mensaje']);

                return $array;
            } else {

                $array = array("error" => 1, 'url' => "");
                return  $array;
            }
        } catch (PDOException $e) {
            //$this->sql_LogErrores(basename($this->file), $sql,clear_string($e->getMessage()), $process,$id);
            return   $array = array("error" => 1, 'url' => "", 'msj' => $e->getMessage());
        }
    }



    public function enviar_factura($email, $asunto, $texto, $adjuntos)
    {


        try {

            $url = '';
            $correo = $email;
            //Informacion Sendgrip
            $apiSendgrip = $this->obtenerApiSendgrip();
            $emailRemitente = $apiSendgrip['correo'];
            $nombreRemitente = $apiSendgrip['correo_nombre'];
            $host = $apiSendgrip['host'];
            $hash = $apiSendgrip['hash'];
            //Enviar Email
            $respuestaEmail = Email_Sendgrid(
                $asunto,
                $this->correo_body($url, $texto),
                $correo,
                null,
                $adjuntos,
                $emailRemitente,
                $nombreRemitente,
                $host,
                $hash
            );

            //Guardamos el Email log
            //$resemail = $this->guardarEmail($data['email'], $respuestaEmail['codigo'], $respuestaEmail['id_mensaje']);
            //return $resemail;
            $array = array("error" => 0, "url" => $url, "id_message" => $respuestaEmail['id_mensaje']);

            return $array;
        } catch (PDOException $e) {
            //$this->sql_LogErrores(basename($this->file), $sql,clear_string($e->getMessage()), $process,$id);
            return   $array = array("error" => 1, 'url' => "", 'msj' => $e->getMessage());
        }
    }

    public function body($url)
    {

        $html = '<!doctype html>
            <html lang="es">
            <head>
                <meta charset="UTF-8" />
                <meta name="viewport" content="width=device-width, initial-scale=1.0" />
            </head>
            
            <body>
            
            <style type="text/css">
              .boton_personalizado{
                text-decoration: none;
                padding: 8px;
                font-weight: 600;
                font-size: 20px;
                color: #ffffff;
                background-color: #00a8df;
                border-radius: 6px;
                border: none;
              }
            
                .boton_personalizado:hover{
                color: white;
                background-color: #363338 ;
                    transition: 0.5s;
              }
            
                *{
              font-family: Arial, Helvetica, sans-serif;
            }
            </style>
            <div style="
            width: 25em;
            margin-top: 5em;
            margin-bottom:: 5em;
            margin-left: auto;
            margin-right: auto;
            text-align: center;
            background-color: white;
            border-radius: 20px;
            box-shadow: 0.1px 0.1px 20px  gray;
            ">
            <div style="padding: 3em 1em 2em 1em ;text-align: center;">
            <img style="width: 50%" src="http://185.184.143.25/yupi/images/logo%20yupi.png" alt="logo">
            
            <h3> ¡Hola! ¿Has olvidado tu contraseña? </h3>
            <p>Puedes hacer clic en este enlace para cambiar tu contraseña:</p>
            
            <a class="boton_personalizado" href="' . $url . '"> Restablecer Contraseña </a>
            
            
            <p>Si no solicitaste reestablecer tu contraseña borra este email</p>
            </div>
            
            <div style="background-color:#ce0fb1; border-bottom-left-radius:20px; border-bottom-right-radius: 20px; padding:1px; color:white;text-align: center;">
            <p>¡Que tengas un hermoso día!
            <br>
            <br>El equipo de YUPI</p>
            
            </div>
            </div>
            
            </body></html>';

        $message = "<p style='border: none;padding: 0;margin: 0;  background-color: #ffffff;color: #000000;font-size: 40px;font-weight: 700;letter-spacing: -0.36px;line-height: 48px;text-align: center;'>¡Hola!</p><br />";
        $message .= "<br />";
        $message .= "No te preocupes. Para restablecer tu contraseña, haz clic en el siguiente enlace:<br />";
        $message .= "<a href='" . $url . "' target='_blank' rel='noopener noreferrer' data-auth='NotApplicable' style='text-decoration:none; color:#45768c;font-weight: 700;'>Restablecer contraseña</a><br />";
        $message .= "Si no solicitaste restablecer tu contraseña, borra este mensaje.<br />";
        $message .= "Un saludo, <br />";
        $message .= "El equipo de Phood.me";

        return  $html;
    }

    public function obtenerCuerpoEmail($tipo)
    {

        $sql = "";
        $process = "Consultar el registro Comercio";

        try {

            $sql =
                "SELECT * FROM configuracion_email where rowid = :tipo";

            $db  = $this->db->prepare($sql);
            $db->bindValue(':tipo', $tipo, PDO::PARAM_STR);
            $db->execute();
            $data = $db->fetch(PDO::FETCH_ASSOC);

            //Registros en log success
            $detail  =  'Registro ' . $tipo . ' consultado en la tabla fi_comercios';
            //  $this->log_success( $this->file,$codigo,$process,$detail);

            // RETURN
            return $data;
        } catch (PDOException  $e) {
            //Registros en log error
            //  $this->sql_LogErrores( $this->file, $sql,clear_string($e->getMessage()), $process);
            return 0;
        }
    }



    public function correo_body($url, $mensaje)
    {

        $html = '<!doctype html>
          <html lang="es">
          <head>
              <meta charset="UTF-8" />
              <meta name="viewport" content="width=device-width, initial-scale=1.0" />
          </head>
          
          <body>
          
          <style type="text/css">
            .boton_personalizado{
              text-decoration: none;
              padding: 8px;
              font-weight: 600;
              font-size: 20px;
              color: #ffffff;
              background-color: #00a8df;
              border-radius: 6px;
              border: none;
            }
          
              .boton_personalizado:hover{
              color: white;
              background-color: #363338 ;
                  transition: 0.5s;
            }
          
              *{
            font-family: Arial, Helvetica, sans-serif;
          }
          </style>
          <div style="
          width: 25em;
          margin-top: 5em;
          margin-bottom:: 5em;
          margin-left: auto;
          margin-right: auto;
          text-align: center;
          background-color: white;
          border-radius: 20px;
          box-shadow: 0.1px 0.1px 20px  gray;
          ">
          <div style="padding: 3em 1em 2em 1em ;text-align: center;">
         
          
          ' . $mensaje . '
          

          
          
      
          </div>
          
          <div style="background-color:#3c8dbc; border-bottom-left-radius:20px; border-bottom-right-radius: 20px; padding:1px; color:white;text-align: center;">
          <p>¡Que tengas un hermoso día!
          <br>
          <br>El equipo de Fpymes</p>
          
          </div>
          </div>
          
          </body></html>';

        $message = "<p style='border: none;padding: 0;margin: 0;  background-color: #ffffff;color: #000000;font-size: 40px;font-weight: 700;letter-spacing: -0.36px;line-height: 48px;text-align: center;'>¡Hola!</p><br />";
        $message .= "<br />";
        $message .= "No te preocupes. Para restablecer tu contraseña, haz clic en el siguiente enlace:<br />";
        $message .= "<a href='" . $url . "' target='_blank' rel='noopener noreferrer' data-auth='NotApplicable' style='text-decoration:none; color:#45768c;font-weight: 700;'>Restablecer contraseña</a><br />";
        $message .= "Si no solicitaste restablecer tu contraseña, borra este mensaje.<br />";
        $message .= "Un saludo, <br />";
        $message .= "El equipo de Phood.me";

        return  $html;
       // return $mensaje;
    }

    public function guardarEmail($correo, $codigo_respuesta, $msg_id)
    {


        $sql = "insert into log_correo SET " .
            "fk_empresa=:fk_empresa," .
            "fk_usuario=:fk_usuario, " .
            "correo=:correo, " .
            "fecha=:fecha, " .
            "codigo_respuesta=:codigo_respuesta, " .
            "tipo_correo=1, " .
            "msg_id=:msg_id ";
        $db  = $this->db->prepare($sql);
        $db->bindValue(':fk_empresa', $this->fk_empresa, PDO::PARAM_INT);
        $db->bindValue(':fk_usuario', $this->fk_usuario, PDO::PARAM_INT);
        $db->bindValue(':correo', $correo, PDO::PARAM_STR);
        $db->bindValue(':fecha', date("Y-m-d H:i:s"), PDO::PARAM_STR);
        $db->bindValue(':codigo_respuesta', $codigo_respuesta, PDO::PARAM_STR);
        $db->bindValue(':msg_id', $msg_id, PDO::PARAM_STR);
        $db->execute();

        return $db;
    }

    public function generarTokenExpiracion($email)
    {
        $md5 = md5($email . date("Y-m-d H:i:sa"));
        $sql = "update fi_usuarios SET token=:token,expiracion=DATE_ADD(NOW(), INTERVAL 2 MINUTE )  WHERE email=:email ";
        $db  = $this->db->prepare($sql);
        $db->bindValue(':email', $email, PDO::PARAM_STR);
        $db->bindValue(':token', $md5, PDO::PARAM_STR);
        $db->execute();

        return $md5;
    }

    public function obtenerApiSendgrip()
    {

        $sql   = "SELECT rowid,correo,correo_nombre,host,hash FROM configuracion_api_sendgrip LIMIT 1";
        $db = $this->db->prepare($sql);
        $db->execute();
        $data  = $db->fetch(PDO::FETCH_ASSOC);

        return $data;
    }


    public function cambiarClave($email, $clave, $id)
    {
        $sql = "";
        $process = "Actualización en el registro Usuario";
        $id = intval($id);
        try {

            // QUERY
            $sql = "UPDATE fi_usuarios SET clave =:clave WHERE email =:email";
            $db  = $this->db->prepare($sql);
            $db->bindValue(':email', $email, PDO::PARAM_STR);
            $db->bindValue(':clave', $clave, PDO::PARAM_STR);
            $result = $db->execute();

            //Registros en log success
            $record  = intval($id);
            $detail  =  'Registro ' . $record . ' consultado en la tabla fi_usuarios';
            $this->log_success(basename($this->file), $record, $process, $detail, $id);

            // RETURN
            return  1;
        } catch (PDOException  $e) {
            //Registros en log error
            $this->sql_LogErrores(basename($this->file), $sql, clear_string($e->getMessage()), $process, 0);
            return 0;
            //0=error
        }
    }
}  // Fin de la Clase 
