<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
<!-----------------facturas_cliente.tpl----------------------->
<?php 
  $totalColon = 0;
  $totalDolar = 0;
  $mostrar    = false;
  $sql        = "SELECT  
                  rowid , 
                  referencia  AS referencia,
                  fecha       AS fecha,
                  total       AS total,
                  (CASE WHEN moneda = 1 THEN total ELSE 0 END) AS colones,
                  (CASE WHEN moneda = 2 THEN total ELSE 0 END) AS dolares,
                  pagado      AS pagado,
                  estado      AS estado
                FROM fi_facturas 
                WHERE fk_tercero = ".$cliente->id." ORDER BY DATE_FORMAT(fecha, '%Y-%m-%d'); ";
  $db         = $dbh->prepare($sql);
  $db->execute();
  // RECORRE LOS REGISTROS
  while($fac=$db->fetch(PDO::FETCH_OBJ)){                                    
    $mostrar  = true;   
    // VALIDA EL ESTADO DE LA FACTURA
    if ($fac->estado==1 and $fac->pagado < $fac->total){ 
      $referencia='<small class="label pull-right bg-yellow">Factura '.$fac->referencia.'</small>'; 
      $pagado='<small class="label pull-right bg-yellow">No</small>';
    }
    // VALIDA EL ESTADO DE LA FACTURA Y EL PAGO
    if ($fac->estado==1 and $fac->pagado >= $fac->total){ $referencia='<small class="label pull-right bg-blue">Factura '.$fac->referencia.'</small>'; 
      $pagado= '<small class="label pull-right bg-blue">Si</small>';
    }
    // VALIDA LA DEFINICION DEL MONTO EN COLONES
    if (($fac->colones) == 0)
      $facturas.= '<tr><td><a href="'.ENLACE_WEB.'dashboard.php?accion=ver_factura&fiche='.$fac->rowid.'"> '.$referencia.'</a></td><td>'.date('d-m-Y',strtotime($fac->fecha)).'</td><td>-</td><td>'.numero_dolar($fac->dolares).'</td><td>'.$pagado.'</td></tr>';
    else
      $facturas.= '<tr><td><a href="'.ENLACE_WEB.'dashboard.php?accion=ver_factura&fiche='.$fac->rowid.'"> '.$referencia.'</a></td><td>'.date('d-m-Y',strtotime($fac->fecha)).'</td><td>'.numero($fac->colones).'</td><td>-</td><td>'.$pagado.'</td></tr>';
    // CALCULA LOS TOTALES
    $totalColon += $fac->colones;
    $totalDolar += $fac->dolares;
  }
?>

<?php if ($mostrar) { ?>

			<div class="box">
                <div class="box-header">
                  <h3 class="box-title">Facturación <?php  echo returnSplitNameClient($cliente->nombre); ?></h3>
                </div><!-- /.box-header -->
                <div class="box-body no-padding">
                    <div id="example1_wrapper" class="dataTables_wrapper form-inline" role="grid">
                        <div class="row">
                            <div class="col-xs-12">
                                <div class="dataTables_filter" id="example1_filter">
                                  <table id="lista_facturas" class="table table-condensed table-hover display dataTable">
                                    <thead>
                                      <tr>
                                        <th style="width: 20px">Factura</th>
                                        <th>Fecha</th>
                                        <th>Colón</th>
                                        <th>Dolar</th>
                                        <th style="width: 10px">Pagado</th>
                                      </tr>                        
                                    </thead>                    
                                    <tbody>       
                                      <!-- LISTADO DE FACTURAS -->            
                                      <?php echo $facturas;  ?>                    
                                    </tbody>
                                    <!-- TOTALES -->
                                    <tr>
                                      <td style="font-weight: bold;">Totales:</td>
                                      <td></td>
                                      <td style="font-weight: bold;"><?php echo numero($totalColon);?></td>
                                      <td style="font-weight: bold;"><?php echo numero_dolar($totalDolar);?></td>
                                      <td></td>
                                    </tr>                  
                                  </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div><!-- /.box-body -->
             
<?php  } else  { ?>


<div class="box">
                <div class="box-header">
                  <h3 class="box-title"><i class="fa fa-fw fa-bell-o"></i> Cliente <?php  echo $cliente->nombre; ?> No cuenta con historial de Facturas</h3>
                </div><!-- /.box-header -->
 </div>


<?php } ?>

<!------------------fin facturas_cliente.tpl------------------->
<script>
$(document).ready(function() {
    $('#lista_facturas').DataTable( {
        "scrollY":        "275px",
        "scrollCollapse": true,
        "paging":         false
    } );
} );
</script>