<?php
/**
 * Created by PhpStorm.
 * User: xavier
 * Date: 10/28/17
 * Time: 8:17 PM
 */

require __DIR__ . '/vendor/autoload.php';

define ("EXP",6000000);
setlocale (LC_CTYPE, 'es_ES');
ini_set ("display_errors","1");
ini_set ("memory_limit","-1");


define('OAUTH2_CLIENT_ID', 'api-stag');
define('OAUTH_CONSUMER_KEY', 'cpf-01-1501-0959@stag.comprobanteselectronicos.go.cr' );
define('OAUTH_CONSUMER_SECRET', "cpf-01-1501-0959@stag.comprobanteselectronicos.go.cr" );
define('grant_type' , 'authorization_code');
define('Response_Type' , 'token');

define('Authorization_Grants' , 'password');
define('Client_Id' ,'api-stag');
define('Client_Secret' ,'');
define('Scope' , '');
define('content-type' , 'application/x-www-form-urlencoded');

define('Username' , 'cpf-01-1501-0959@stag.comprobanteselectronicos.go.cr');
define('Password' , ')a+_;6=dSm|Zd&WW:M)+');

define('Staging_Auth_Url',
    'https://idp.comprobanteselectronicos.go.cr/auth/realms/rut-stag/protocol/openid-connect/token');
define('Staging_Recepcion_Url',
    'https://api.comprobanteselectronicos.go.cr/recepcion-sandbox/v1/recepcion');

ini_set('allow_url_fopen',1);


//Invalid protected resource url, unable to generate signature base string
echo "Iniciando..." . "\n";

$client = new \GuzzleHttp\Client([
    'timeout' => 4.0,
]);

$body = [
    'client_id' => Client_Id,
    'username' => Username,
    'password' => Password,
    'client_secret' => Client_Secret,
    'scope' => Scope,
    'grant_type' => Authorization_Grants,
];

$contentObj = null;

try {
    echo 'Obteniendo credenciales:';
    $response = $client->request('POST', Staging_Auth_Url, ['form_params' => $body]);

    $content = $response->getBody()->getContents();
    $contentObj = json_decode($content);

    echo  "OK!\n";

} catch(Exception $E) {
    echo "Error!\n";
}

$access_token = $contentObj->access_token;


$factura = file_get_contents('./MockAssets/mock_invoice.xml', FILE_USE_INCLUDE_PATH);
$facturaBase64 = base64_encode($factura);
$clave = '50601011600310112345600100010100000000011999999901';
$mockBody = sprintf('
{
  "clave": "%s",
  "fecha": "2016-01-01T00:00:00-0600",
  "emisor": {
    "tipoIdentificacion": "02",
    "numeroIdentificacion": "3101123456"
  },
  "receptor": {
    "tipoIdentificacion": "02",
    "numeroIdentificacion": "3101123456"
  },
  "comprobanteXml":"%s"
}', $clave, $facturaBase64);

$body = json_decode($mockBody);
try {
    echo 'Enviando comprobante:';
    $response = $client->request(
        'POST',
        Staging_Recepcion_Url,
        [
            'json' => $body,
            'headers' =>
                [
                    'Authorization' => "Bearer {$access_token}",
                    'Content-Type' => 'application/json',
                ]
        ]
    );

    $content = $response->getBody()->getContents();
    $contentObj = json_decode($content);

    echo  "OK!\n";
} catch(Exception $E) {

    $headers = $response = $E->getResponse()->getHeaders();

    echo 'Errores:' . "\n";
    foreach ($headers['X-Error-Cause'] as $error) {
        echo $error . "\n";
    }
}

try {
    echo 'Recibiendo resultado de comprobante:';
    $response = $client->request(
        'GET',
        Staging_Recepcion_Url . '/' . $clave,
        [
            'headers' =>
                [
                    'Authorization' => "Bearer {$access_token}",
                    'Content-Type' => 'application/json',
                ]
        ]
    );

    $content = $response->getBody()->getContents();
    $contentObj = json_decode($content);
    $respuestaXmlBase64 = $contentObj->{'respuesta-xml'};
    $respuestaXmlTxt = base64_decode($respuestaXmlBase64);
    $respuestaXml = new SimpleXMLElement($respuestaXmlTxt);
    echo  "OK!\n";
    echo  "Resultado: \n";
    if ((int) $respuestaXml->Mensaje === 3) {
        throw new Exception((string) $respuestaXml->DetalleMensaje);
    }
    echo $respuestaXmlTxt;
} catch(Exception $E) {
    echo 'Errores:' . "\n";
    echo $E->getMessage(). "\n";
}
