<?php

SESSION_START();
include_once("../../conf/conf.php");

// VALID DEFINITIO ACTION
if (! empty($_POST['action'])):
	$name 	= $_POST['name'];
	$rowid 	= $_POST['parent'];
    // VALID ACTION    
    switch($_POST['action']):
        case 'addTypesExpenses':
            addTypesExpenses($dbh, $name, $rowid);
        break;     
        case 'editTypesExpenses':
            editTypesExpenses($dbh, $name, $rowid);
        break; 
        case 'deleteTypesExpenses':
            deleteTypesExpenses($dbh, $name, $rowid);
        break;      
    endswitch;
endif;

// FUNCION ADD TYPE EXPENSES INFO
function addTypesExpenses($dbh, $name, $parent){
	$query = 
	    "INSERT INTO fi_gastos_tipos 
		(nombre, entidad, fk_parent, activo)
		VALUE
		(:nombre, :entidad, :fk_parent, 1);";
	$db = $dbh->prepare($query);
	$db->bindValue(':nombre', $name, 	PDO::PARAM_STR);
	$db->bindValue(':entidad', $_SESSION['Entidad'], PDO::PARAM_INT);
	$db->bindValue(':fk_parent', $parent, PDO::PARAM_INT);
	$result = $db->execute();
	echo($result);
}  

// FUNCION ADD TYPE EXPENSES INFO
function editTypesExpenses($dbh, $name, $rowid){
	$query = "UPDATE fi_gastos_tipos SET nombre = :nombre WHERE entidad = :entidad AND rowid = :rowid;";
	$db = $dbh->prepare($query);
	$db->bindValue(':nombre', $name, 	PDO::PARAM_STR);
	$db->bindValue(':entidad', $_SESSION['Entidad'], PDO::PARAM_INT);
	$db->bindValue(':rowid', $rowid, PDO::PARAM_INT);
	$result = $db->execute();
	echo($result);
} 

// FUNCION ADD TYPE EXPENSES INFO
function deleteTypesExpenses($dbh, $name, $rowid){
	$query = "UPDATE fi_gastos_tipos SET activo = 0 WHERE entidad = :entidad AND rowid = :rowid;";
	$db = $dbh->prepare($query);
	$db->bindValue(':entidad', $_SESSION['Entidad'], PDO::PARAM_INT);
	$db->bindValue(':rowid', $rowid, PDO::PARAM_INT);
	$result = $db->execute();
	echo($result);
} 